/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWRolesTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    protected static final int COL_NAME = 0;
    private VWSessionInfo m_sessionInfo = null;
    private VWApplicationSpaceDefinition m_appSpaceDef = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWRolesTableModel(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_rowData = new Vector();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWRoleDefinition roleDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (roleDef == null) break;
                    return roleDef.getName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setApplicationSpaceDefinition(VWApplicationSpaceDefinition appSpaceDef) {
        try {
            try {
                VWRoleDefinition[] roleDefs;
                this.m_appSpaceDef = appSpaceDef;
                this.m_rowData = new Vector();
                if (this.m_appSpaceDef != null && (roleDefs = this.m_appSpaceDef.getRoleDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < roleDefs.length; ++nIndex) {
                        this.m_rowData.addElement(roleDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void addNewRole() throws Exception {
        String newRoleName = this.generateDefaultName(VWResource.RoleNameNewTemplate, 0);
        VWRoleDefinition newRoleDef = this.m_appSpaceDef.createRoleDefinition(newRoleName);
        this.m_rowData.addElement(newRoleDef);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void copyRoleAtIndex(int nRowIndex) {
        try {
            String copyOfString;
            VWRoleDefinition newRoleDef;
            VWRoleDefinition roleDef = this.getRowItemAt(nRowIndex);
            if (roleDef != null && (newRoleDef = this.m_appSpaceDef.createCopyOfRoleDefinition(copyOfString = this.generateDefaultName(VWResource.CopyOf.toString(roleDef.getName()), 0), roleDef)) != null) {
                this.m_rowData.addElement(newRoleDef);
                this.m_bIsModified = true;
                int nLastRow = this.getRowCount() - 1;
                this.fireTableRowsInserted(nLastRow, nLastRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void deleteRoleAtIndex(int nRowIndex) {
        try {
            VWRoleDefinition roleDef = this.getRowItemAt(nRowIndex);
            this.m_appSpaceDef.deleteRoleDefinition(roleDef.getName());
            this.m_rowData.removeElement(roleDef);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected VWRoleDefinition getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWRoleDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_appSpaceDef = null;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            VWRoleDefinition roleDef = this.getRowItemAt(nRowIndex);
            if (roleDef != null) {
                roleDef.setName((String)aValue);
                this.m_bIsModified = true;
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private String generateDefaultName(String template, int postfix) throws VWException {
        int rowCount = this.m_rowData.size();
        boolean bHasDup = false;
        String defaultName = template;
        do {
            bHasDup = false;
            for (int j = 0; j < rowCount; ++j) {
                VWRoleDefinition roleDef = (VWRoleDefinition)this.m_rowData.elementAt(j);
                if (defaultName.compareTo(roleDef.getName()) != 0) continue;
                defaultName = String.format("%s_%d", template, ++postfix);
                bHasDup = true;
                break;
            }
            if (bHasDup || this.m_appSpaceDef.getRoleDefinition(defaultName) == null) continue;
            defaultName = String.format("%s_%d", template, ++postfix);
            bHasDup = true;
        } while (bHasDup);
        return defaultName;
    }
}

